package cn.smarthse.rho.modules.sys.enums.wanda;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FswsErrorDataTableTypeEnum {

    FSWS_HOSPITAL_INFO("fsws_hospital_info", 1),
    FSWS_ZWY_DEVICE_INFO("fsws_zwy_device_info", 2),
    FSWS_RHO_DEVICE_INFO("fsws_rho_device_info", 3),
    FSWS_ZWY_PLACE_INFO("fsws_zwy_place_info", 4),
    FSWS_RHO_PLACE_INFO("fsws_rho_place_info", 5),
    FSWS_HEALTH_CARD("fsws_health_card", 10),
    FSWS_HC_FACTORS("fsws_hc_factors", 11),
    FSWS_HC_DIAGS("fsws_hc_diags", 12),
    FSWS_HC_C_FACTORS("fsws_hc_c_factors", 13),
    FSWS_DEVICE_CHECK("fsws_device_check", 14),
    FSWS_DEVICE_CHECK_DATA("fsws_device_check_data", 15),
    FSWS_PLACE_CHECK("fsws_place_check", 16),
    FSWS_PLACE_CHECK_DATA("fsws_place_check_data", 17),
    FSWS_DOSE_MONITOR("fsws_dose_monitor", 18),
    FSWS_DOSE_MONITOR_DATA("fsws_dose_monitor_data", 19),
    //FSWS_ERROR_DATA_RETURN_LOG("fsws_error_data_return_log", 20),
    ;

    /**
     * 表名
     */
    private final String name;
    private final int value;

}

