package cn.smarthse.rho.modules.sys.enums.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 用户类型  单位用户-1；机构用户-2；监管用户-3
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/3/13 15:01
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum UserTypeEnum {

    /**
     * 单位用户-1
     */
    company("单位用户", 1),

    /**
     * 机构用户-2
     */
    org("机构用户", 2),

    /**
     * 监管用户-3
     */
    supervise("监管用户", 3),
    ;

    /**
     * 成员变量
     */
    private String name;
    private Integer value;

    UserTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (UserTypeEnum c : UserTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static UserTypeEnum getState(Integer value) {
        if (value == null) {
            return null;
        }
        for (UserTypeEnum c : UserTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return null;
    }

}
