package cn.smarthse.rho.modules.sys.enums.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 用户来源（1-用户手动新增；2-监管添加；3-运维添加；4-监管单点添加）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/3/13 15:01
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum UserResourceEnum {

    /**
     * 用户手动新增
     */
    MANUALLY_ADD("用户手动新增", "MANUALLY", 1),

    /**
     * 监管添加
     */
    SUPERVISE_ADD("监管添加", "SUPERVISE", 2),

    /**
     * 运维添加
     */
    MAINTENANCE_ADD("运维添加", "MAINTENANCE", 3),

    /**
     * 监管单点添加
     */
    SUPERVISE_SINGLE_ADD("监管单点添加", "SUPERVISE_SINGLE", 4),

    /**
     * wanda同步
     */
    WANDA_SYNC_ADD("wanda", "WANDA_SYNC", 5),

    ;

    private final String name;
    private final String mark;
    private final Integer value;

    UserResourceEnum(String name, String mark, Integer value) {
        this.name = name;
        this.mark = mark;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (UserResourceEnum c : UserResourceEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static UserResourceEnum getState(Integer value) {
        if (value == null) {
            return null;
        }
        for (UserResourceEnum c : UserResourceEnum.values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return null;
    }
}
