package cn.smarthse.rho.modules.sys.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训项目-数据来源枚举
 *
 * @author wuxq
 * @date: 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainingSourceEnum {

    COMPANY("系统新增", 1),

    ONLINE("在线培训", 2),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainingSourceEnum[] values = TrainingSourceEnum.values();
        for (TrainingSourceEnum certificateStaffDetailDataSourceEnum : values) {
            if (certificateStaffDetailDataSourceEnum.getValue().equals(value)) {
                return certificateStaffDetailDataSourceEnum.getName();
            }
        }
        return "";
    }

}
