package cn.smarthse.rho.modules.sys.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训人员证书-考核结果
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainingCertResultEnum {

    UNQUALIFIED("未通过", 0),
    QUALIFIED("通过", 1),

    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainingCertResultEnum[] values = TrainingCertResultEnum.values();
        for (TrainingCertResultEnum certTypeEnum : values) {
            if (certTypeEnum.getValue().equals(value)) {
                return certTypeEnum.getName();
            }
        }
        return "";
    }

}
