package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysChangeLogEnum {

    // b_company
    company_is_main(1001, "b_company", "is_main", "是否是主院变更"),
    company_hospital_name(1002, "b_company", "hospital_name", "放射诊疗机构名称变更"),
    company_name(1003, "b_company", "name", "附属对象(院区)名称变更"),
    company_credit_code(1004, "b_company", "credit_code", "统一社会信用代码变更"),
    company_business_status(1005, "b_company", "business_status", "营业状态变更"),
    company_area_id(1006, "b_company", "area_id", "行政区划变更"),
    company_state(1007, "b_company", "state", "院区状态变更"),
    company_legal_name(1008, "b_company", "legal_name", "法人代表姓名变更"),
    company_legal_tel(1009, "b_company", "legal_tel", "法人代表联系电话变更"),
    company_main_leader_name(1010, "b_company", "main_leader_name", "主要负责人变更"),
    company_main_leader_tel(1011, "b_company", "main_leader_tel", "主要负责人联系电话变更"),
    company_belong_type(1012, "b_company", "belong_type", "直属类型变更"),
    company_supervision_unit(1013, "b_company", "supervision_unit", "监督单位变更"),
    company_medical_nucode(1014, "b_company", "medical_nucode", "全国唯一标识码变更"),
    company_licence_status(1015, "b_company", "licence_status", "许可证状态变更"),

    // c_staff_base_info
    c_staff_base_info_name(2001, "c_staff_base_info", "name", "姓名变更"),
    c_staff_base_info_phone(2002, "c_staff_base_info", "phone", "手机号变更"),


    // c_staff
    c_staff_base_id(3001, "c_staff", "post", "人员基础信息id变更"),
    c_staff_cid(3002, "c_staff", "cid", "单位id变更"),


    // sys_user
    sys_user_username(4001, "sys_user", "username", "账号名称变更"),


    // g_equipment_self_check
    g_equipment_self_check_check_time(5001, "g_equipment_self_check", "check_time", "自查时间修改"),
    g_equipment_self_check_certificate_file(5002, "g_equipment_self_check", "certificate_file", "佐证材料修改"),
    g_equipment_self_check_name(5003, "g_equipment_self_check", "name", "承诺人修改"),
    g_equipment_self_check_phone(5004, "g_equipment_self_check", "phone", "联系电话修改"),
    g_equipment_self_check_commitment_file(5005, "g_equipment_self_check", "commitment_file", "承诺书修改"),
    g_equipment_self_check_status(5006, "g_equipment_self_check", "status", "退回"),
    // g_safety_device_self_check
    g_safety_device_self_check_check_time(6001, "g_safety_device_self_check", "check_time", "自查时间修改"),
    g_safety_device_self_check_certificate_file(6002, "g_safety_device_self_check", "certificate_file", "佐证材料修改"),
    g_safety_device_self_check_name(6003, "g_safety_device_self_check", "name", "承诺人修改"),
    g_safety_device_self_check_phone(6004, "g_safety_device_self_check", "phone", "联系电话修改"),
    g_safety_device_self_check_commitment_file(6005, "g_safety_device_self_check", "commitment_file", "承诺书修改"),
    g_safety_device_self_check_status(6006, "g_safety_device_self_check", "status", "退回"),


    // e_device
    e_device_name(7001, "e_device", "name", "设备名称变更"),
    e_device_factory_no(7002, "e_device", "factory_no", "设备编号变更"),
    e_device_factory(7003, "e_device", "factory", "生产厂家变更"),
    e_device_status(7004, "e_device", "status", "设备状态变更"),
    e_device_type(7005, "e_device", "type", "设备类型变更"),
    e_device_use_to(7006, "e_device", "use_to", "核素用途变更"),
    e_device_license_status(7007, "e_device", "license_status", "许可状态变更"),
    e_device_use_department_id(7008, "e_device", "use_department_id", "使用科室id变更"),
    // e_device_ray
    e_device_ray_category(7101, "e_device_ray", "category", "射线类别变更"),
    e_device_ray_mobility_type(7102, "e_device_ray", "mobility_type", "设备移动类型变更"),
    e_device_ray_is_bedside(7103, "e_device_ray", "is_bedside", "是否床边机变更"),
    e_device_ray_diagnosis_type(7104, "e_device_ray", "diagnosis_type", "放射诊疗类别变更"),
    e_device_ray_model(7105, "e_device_ray", "model", "设备型号变更"),
    e_device_ray_parameters(7106, "e_device_ray", "parameters", "主要参数变更"),
    e_device_ray_bulb_num(7107, "e_device_ray", "bulb_num", "球管个数变更"),
    e_device_ray_check_type(7108, "e_device_ray", "check_type", "放射检查类型变更"),
    e_device_ray_production_date(7109, "e_device_ray", "production_date", "出厂日期变更"),
    e_device_ray_installation_unit(7110, "e_device_ray", "installation_unit", "安装单位变更"),
    e_device_ray_person_in_charge(7111, "e_device_ray", "person_in_charge", "负责人变更"),
    // e_device_source
    e_device_source_model(7201, "e_device_source", "model", "设备型号变更"),
    e_device_source_diagnosis_type(7202, "e_device_source", "diagnosis_type", "放射诊疗类别变更"),
    e_device_source_person_in_charge(7203, "e_device_source", "person_in_charge", "负责人变更"),
    // e_source_non_sealed
    e_source_non_sealed_physical_state(7301, "e_source_non_sealed", "physical_state", "物理状态变更"),
    e_source_non_sealed_data1(7302, "e_source_non_sealed", "data1", "最大等效日操作量底数变更"),
    e_source_non_sealed_data2(7303, "e_source_non_sealed", "data2", "最大等效日操作量指数变更"),
    e_source_non_sealed_data3(7304, "e_source_non_sealed", "data3", "最大等效年操作量底数变更"),
    e_source_non_sealed_data4(7305, "e_source_non_sealed", "data4", "最大等效年操作量指数变更"),
    e_source_non_sealed_data5(7306, "e_source_non_sealed", "data5", "出厂活度底数变更"),
    e_source_non_sealed_data6(7307, "e_source_non_sealed", "data6", "出厂活度指数变更"),
    e_source_non_sealed_person_in_charge(7308, "e_source_non_sealed", "person_in_charge", "负责人变更"),
    // e_source_sealed
    e_source_sealed_unique_code(7401, "e_source_sealed", "unique_code", "国家编码变更"),
    e_source_sealed_data1(7402, "e_source_sealed", "data1", "出厂活度底数变更"),
    e_source_sealed_data2(7403, "e_source_sealed", "data2", "出厂活度指数变更"),
    e_source_sealed_measurement_date(7404, "e_source_sealed", "measurement_date", "活度测量日期变更"),
    e_source_sealed_production_date(7405, "e_source_sealed", "production_date", "出厂日期变更"),
    e_source_sealed_person_in_charge(7406, "e_source_sealed", "person_in_charge", "负责人变更"),


    // e_machine_room
    e_machine_room_enable_status(8001, "e_machine_room", "enable_status", "机房启用状态变更"),

    ;

    private final Integer key;
    private final String tableName;
    private final String column;
    private final String value;

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (SysChangeLogEnum remind : SysChangeLogEnum.values()) {
            if (Objects.equals(key, remind.getKey())) {
                return remind.getValue();
            }
        }
        return null;
    }

    public static SysChangeLogEnum[] getByTableName(String tableName) {

        return Arrays.stream(SysChangeLogEnum.values())
                .filter(c -> tableName.equals(c.getTableName()))
                .toArray(SysChangeLogEnum[]::new);
    }
    public static String getValueByTableAndField(String tableName, String column) {
        if (tableName == null || column == null) {
            return null;
        }
        for (SysChangeLogEnum item : SysChangeLogEnum.values()) {
            if (item.getTableName().equals(tableName) && item.getColumn().equals(column)) {
                return item.getValue();
            }
        }
        return null;
    }

}
