package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 系统业务数据操作记录
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysBusinessOperateLogTypeEnum {

    DRAFT("存草稿",0),
    SUBMIT("提交", 1),
    BACK("退回", 2),
    PASS("审核通过", 3),
    TERMINATED("已终止", 5);

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        for (SysBusinessOperateLogTypeEnum c : SysBusinessOperateLogTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
