package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 系统业务数据操作记录
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysBusinessOperateLogModuleEnum {

    /**
     * 关键因素画像
     */
    KEY_FACTOR_AUDIT_1("关键因素画像审核-培训", 106),
    KEY_FACTOR_AUDIT_2("关键因素画像审核-三同时", 107),
    KEY_FACTOR_AUDIT_3("关键因素画像审核-个人防护用品", 108),
    KEY_FACTOR_AUDIT_4("关键因素画像审核-安全装置与警示标识", 109),

    /**
     * 放射防护培训档案
     */
    RADIATION_TRAIN_1("放射防护培训档案", 201),
    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        for (SysBusinessOperateLogModuleEnum c : SysBusinessOperateLogModuleEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
