package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@Getter
@AllArgsConstructor
public enum RhoUserRolesEnum {

    RHO_COMPANY_SUPER_ADMIN(5000L, "超级管理员"),
    RHO_COMPANY_COMMON_USER(5001L, "普通用户"),
    ;

    private final Long roleId;
    private final String roleName;

    public static RhoUserRolesEnum getByValue(Long roleId) {
        for (RhoUserRolesEnum userRole : RhoUserRolesEnum.values()) {
            if (userRole.getRoleId().equals(roleId)) {
                return userRole;
            }
        }
        return null;
    }

}
