package cn.smarthse.rho.modules.sys.enums.staff;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 医院等级
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum StaffCertSourceEnum {

	OTHER("其他",0),
	WEI_QI("卫企在线培训同步",1),
	HOSPITAL("医疗机构提交",2),
	SYS_IMPORT("系统导入",3),
	;

	/**成员变量*/
	private final String name;
	private final Integer value;

	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (StaffCertSourceEnum c : StaffCertSourceEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}







}
