package cn.smarthse.rho.modules.sys.enums.staff;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 职业照射种类及代码
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RayCodeEnum {
	NUCLEAR("1","核燃料循环"),
	NUCLEAR_A("1A","铀矿开采1A"),
	NUCLEAR_B("1B","铀矿水治1B"),
	NUCLEAR_C("1C","铀的浓缩和转化1C"),
	NUCLEAR_D("1D","燃料制造1D"),
	NUCLEAR_E("1E","反应堆1E"),
	NUCLEAR_F("1F","燃料后处理1F"),
	NUCLEAR_G("1G","核燃料循环研究1G"),


	MEDICINE("2","医学应用"),
	MEDICINE_A("2A","诊断放射学2A"),
	MEDICINE_B("2B","牙科放射学2B"),
	MEDICINE_C("2C","核医学2C"),
	MEDICINE_D("2D","放射治疗2D"),
	MEDICINE_E("2E","介入放射学2E"),
	MEDICINE_F("2F","其他2F"),


	INDUSTRY("3","工业应用"),
	INDUSTRY_A("3A","工业辐射3A"),
	INDUSTRY_B("3B","工业探伤3B"),
	INDUSTRY_C("3C","发光涂料工业3C"),
	INDUSTRY_D("3D","放射性同位素生产3D"),
	INDUSTRY_E("3E","测井3E"),
	INDUSTRY_F("3F","加速器运行3F"),
	INDUSTRY_G("3G","其他3G"),

	NATURE("4","天然源"),
	NATURE_A("4A","民用航空4A"),
	NATURE_B("4B","煤矿开采4B"),
	NATURE_C("4C","其他矿藏开采4C"),
	NATURE_D("4D","石油和天然气工业4D"),
	NATURE_E("4E","矿物和矿石处理4E"),
	NATURE_F("4F","其他4F"),

	OTHER("5","其他"),
	OTHER_A("5A","教育5A"),
	OTHER_B("5B","兽医学5B"),
	OTHER_C("5C","科学研究5C"),
	OTHER_D("5D","其他5D"),

	;

	/**成员变量*/
	private String code;
	private String name;

	public static String getCode(String name) {
		if (StrUtil.isBlank(name)) {
			return null;
		}
		for (RayCodeEnum c : RayCodeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.code;
			}
		}
		return null;
	}

	public static String getCodeByFuzzyName(String name) {
		if (StrUtil.isBlank(name)) {
			return null;
		}
		for (RayCodeEnum c : RayCodeEnum.values()) {
			if (c.getName().contains(name)) {
				return c.code;
			}
		}
		return null;
	}

	public static String getName(String code) {
		if (StrUtil.isBlank(code)) {
			return null;
		}
		for (RayCodeEnum c : RayCodeEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}



}
