package cn.smarthse.rho.modules.sys.enums.staff;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 体检身份证类型枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum IdCardTypeEnum {

	ID_CARD("1", "居民身份证"),

	HK_MC_HOME_RETURN_PERMIT("2", "港澳居民来往内地通行证"),

	TW_HOME_RETURN_PERMIT("3", "台湾居民来往内地通行证"),

	ID_CARD_HK_MC_TW("4", "港澳台居民居住证"),

	ID_CARD_WXK("5", "外国人永久居留身份证"),

	FOREIGNER_PASSPORT("6", "外籍人士护照"),

	PASSPORT("7", "护照"),

	MILITARY_OFFICER_CARD("8", "军官证"),

	DRIVING_LICENSE("9", "驾驶证"),

	HOUSEHOLD("10", "户口簿"),

	OTHER("99", "其他法定有效证件");

	;

	private final String value;
	private final String name;

	public static String getNameByValue(String value){
		for (IdCardTypeEnum item : IdCardTypeEnum.values()) {
			if (item.value.equals(value)) {
				return item.name;
			}
		}
		return null;
	}

	public static boolean containValue(String value){
		return StrUtil.isNotBlank(getNameByValue( value));
	}


	/**
	 * 是否是中国身份证(大陆 港澳台 外国人永久居留证)
	 * @param idCardType
	 * @return
	 */
	public static boolean isCnCode(String idCardType) {
		if(StrUtil.isBlank(idCardType)){
			return false;
		}
		return IdCardTypeEnum.ID_CARD.getValue().equals(idCardType) || IdCardTypeEnum.ID_CARD_HK_MC_TW.getValue().equals(idCardType) || IdCardTypeEnum.ID_CARD_WXK.getValue().equals(idCardType);
	}
}
