package cn.smarthse.rho.modules.sys.enums.staff;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 体检身份证类型枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum HCIdCardTypeEnum {
	ID_CARD("1", "居民身份证", IdCardTypeEnum.ID_CARD.getValue()),

	HOUSEHOLD("2", "居民户口簿", IdCardTypeEnum.HOUSEHOLD.getValue()),

	PASSPORT("3", "护照", IdCardTypeEnum.PASSPORT.getValue()),

	MILITARY_OFFICER_CARD("4", "军官证", IdCardTypeEnum.MILITARY_OFFICER_CARD.getValue()),

	DRIVING_LICENSE("5", "驾驶证", IdCardTypeEnum.DRIVING_LICENSE.getValue()),

	HK_MC_HOME_RETURN_PERMIT("6", "港澳居民来往内地通行证", IdCardTypeEnum.HK_MC_HOME_RETURN_PERMIT.getValue()),

	TW_HOME_RETURN_PERMIT("7", "台湾居民来往内地通行证", IdCardTypeEnum.TW_HOME_RETURN_PERMIT.getValue()),

	OTHER("99", "其他法定有效证件", IdCardTypeEnum.OTHER.getValue())
	;

	private final String value;
	private final String name;
	private final String rhoValue;


	public static String getRhoIdCartType(String value){
		for (HCIdCardTypeEnum hcIdCardTypeEnum : HCIdCardTypeEnum.values()) {
			if (hcIdCardTypeEnum.getValue().equals(value)) {
				return hcIdCardTypeEnum.getRhoValue();
			}
		}
		return null;
	}








}
