package cn.smarthse.rho.modules.sys.enums.s;


import cn.smarthse.rho.core.framework.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  @author zhangxu
 *  职业卫生监督信息 (检测结果)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SuperviseLawYrdwJcjgEnum {
    one1("1","未发现问题"),
    one2("2","发现问题经责令已改正"),
    one3("3","未发现本次抽查涉及的生产经营活动"),
    one4("4","不配合检查情节严重"),
    one5("5","注销"),
    one6("6","暂停营业"),
    one7("7","吊证"),
    one8("8","关闭已关闭停业或正在组织清算"),
    one9("9","发现问题待后续处理"),//(备注：选择此项，需根据后续处理情况，选择“后续处置”的内容）
    one10("10","通过登记的住所（经营场所）无法联系"),
    one11("11","被撤销"),
    one12("12","迁出"),
    one13("13","未按规定公示应当公示的信息"),
    one14("14","公示信息隐瞒真实情况弄虚作假"),
    ;

    /**
     * 类别编码
     */
    private final String code;
    /**
     * 类别名称
     */
    private final String name;

    public static List<Map<String,Object>> getAllValues() {
        SuperviseLawYrdwJcjgEnum[] tss = SuperviseLawYrdwJcjgEnum.values();
        List<Map<String,Object>> list= new ArrayList<Map<String,Object>>();
        for(SuperviseLawYrdwJcjgEnum ts : tss) {
            Map<String,Object> data = new HashMap<String,Object>();
            data.put("code", ts.getCode());
            data.put("name", ts.getName());
            list.add(data);
        }
        return list;
    }

    public static String getNameByCode(String code) {
        if(StringUtils.isEmpty(code)) return "";
        SuperviseLawYrdwJcjgEnum[] tss = SuperviseLawYrdwJcjgEnum.values();
        for(SuperviseLawYrdwJcjgEnum ts : tss) {
            if(ts.getCode().equals(code)) {
                return ts.getName();
            }
        }
        return "";
    }
}
