package cn.smarthse.rho.modules.sys.enums.risk.defuse;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 体检风险化解原因
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum TrainingDefsuseMeasureEnum {
    COMMON("已同步到有效的培训记录，系统自动化解风险","已同步到有效的培训记录，系统自动化解风险"),
    JOB_ON_TO_DT("人员岗位状态修改，系统自动化解风险","岗位状态：上岗->非上岗"),
    RAY_TRUE_TO_FALSE("人员变更为非放射工作人员，系统自动化解风险","人员类型：放射->非放射"),
    STAFF_REMOVED("该人员已被删除，系统自动化解风险","人员数据被删除"),
    CERT_REMOVED("人员相关培训证明信息有变化，需重新评估风险","培训证书被删除"),
    ;


    private final String measure;
    private final String des;

}
