package cn.smarthse.rho.modules.sys.enums.risk.defuse;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 个人剂量风险化解原因
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DoseDefsuseMeasureEnum {
    COMMON("已同步到有效的个人剂量数据，系统自动化解风险","已同步到有效的个人剂量数据，系统自动化解风险"),
    JOB_ON_TO_DT("人员岗位状态修改，系统自动化解风险","岗位状态：上岗->非上岗"),
    RAY_TRUE_TO_FALSE("人员变更为非放射工作人员，系统自动化解风险","人员类型：放射->非放射"),
    STAFF_REMOVED("该人员已被删除，风险自动化解","人员数据被删除"),
    WE_EDIT("人员工作经历已修改，需重新评估风险","工作经历被删除"),
    POST_START_TIME_BEFORE_SPECIFIC_TIME("人员工作经历已修改，需重新评估风险","上岗时间在特定时间之前"),
    POST_DT_TIME_BEFORE_SPECIFIC_TIME("人员工作经历已修改，需重新评估风险","离岗时间在特定时间之前"),
    SAME_CREDIT_HAS_ON_JOB("人员在同一医院所属院区中工作经历变动，需重新评估风险","同信用代码下，本院区离岗，但其他院区在岗"),
    HC_REMOVED("风险相关个人剂量数据已被删除，需重新评估风险","生成风险的个人剂量数据被删除"),
    TIME_FULL("人员工作经历已修改，需重新评估风险","时间补充完整"),
    HC_CHECK_DATA_BEFORE_SPECIFIC_TIME(null,"个人剂量时间在特定时间之前"),
    ;


    private final String measure;
    private final String des;

}
