package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举 - 预警状态（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskWarningStatusEnum {

	/**
	 *	0-无
	 */
	NONE("无",0),

	/**
	 *	1-首次预警
	 */
	FIRST("首次预警",1),

	/**
	 *	2-黄色预警
	 */
	YELLOW("黄色预警",2),

	/**
	 *	3-红色预警
	 */
	RED("红色预警",3),

	/**
	 *	4-启动执法
	 */
	ACTIVATE_LAW("启动执法",4),
	;

	private String name;
	private Integer value;

	public static String getName(Integer value) {
		for (RiskWarningStatusEnum c : RiskWarningStatusEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}

	/**
	 * 未及时展开的状态
	 * @param status
	 * @return
	 */
	public static boolean isExpiredStatus(Integer status){
		return RiskWarningStatusEnum.RED.getValue().equals(status) || RiskWarningStatusEnum.ACTIVATE_LAW.getValue().equals(status);
	}

	/**
	 * 未及时展开的状态
	 * @param status
	 * @return
	 */
	public static boolean isExpiryDate(Integer status){
		return RiskWarningStatusEnum.FIRST.getValue().equals(status) || RiskWarningStatusEnum.YELLOW.getValue().equals(status);
	}
}
