package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举 - 未化解状态(0-无；11-待整改；12-待验收；13-已退回)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskUnresolvedTypeEnum {

	/**
	 *	0-无
	 */
	NONE("无",0),

	/**
	 *	11-待整改
	 */
	UN_RECTIFY("待整改",11),

	/**
	 *	12-待验收
	 */
	UN_ACCEPT("待验收",12),

	/**
	 *	13-已退回
	 */
	RETURNED("已退回",13),


	;

	private String name;
	private Integer value;



	public static String getName(Integer value) {
		if (value == null) {
			return "";
		}

		for (RiskUnresolvedTypeEnum c : RiskUnresolvedTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}
}
