package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险类型枚举（十四种 = 普通八项 + 异常六项）
 * 注：name不要随意修改，有用于风险名称的生成
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskTypeEnum {

    /**
     * 普通八项：
     * 许可管理、性能检测、场所检测、职业健康体检、个人剂量监测、放射工作人员培训、个人防护用品、安全装置和警示标识
     */
    LICENSE_MANAGEMENT("许可管理", 101),
    PERFORMANCE_TEST("性能检测", 102),
    PLACE_TEST("场所检测", 103),
    PHYSICAL_EXAMINATION("职业健康体检", 104),
    DOSE_MONITORING("个人剂量监测", 105),
    TRAINING("放射工作人员培训", 106),
    PERSONAL_PROTECTIVE_EQUIPMENT("个人防护用品", 108),
    SAFETY_DEVICES_AND_ALERTS("安全装置和警示标识", 109),

    /**
     * 异常六项：
     * 性能检测结果异常、场所检测结果异常、体检结果异常-疑似职业病、体检结果异常-职业禁忌证、体检结果异常-复查、个人剂量监测结果异常-超剂量照射
     */
    EXCEPTION_PERFORMANCE_TEST("性能检测结果异常", 102001),
    EXCEPTION_PLACE_TEST("场所检测结果异常", 103001),
    PHYSICAL_EXCEPTION_OCC("疑似职业病", 104004),
    PHYSICAL_EXCEPTION_CONTRAINDICATION("职业禁忌证", 104005),
    PHYSICAL_EXCEPTION_REVIEW("复查", 104006),
    PHYSICAL_EXCEPTION_OTHER("其他", 1049900),
    DOSE_EXCEPTION_OVERDOSE("超剂量照射", 105002),

    /** 三同时 不算风险（请勿删除）*/
    @Deprecated
    THREE("建设项目“三同时”", 107),

    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }

        for (RiskTypeEnum c : RiskTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
