package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险来源枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskSourceEnum {

    /**
     * 关键因素画像
     */
    PORTRAIT("关键因素画像", 10),
    ;

    private String name;
    private Integer value;

    public static String getName(Integer value) {
        for (RiskSourceEnum c : RiskSourceEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
