package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险岗位状态枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskPostStatusEnum {
	PRE_POST("岗前",1),
	ON_POST("在岗",2),
	DT_POST("离岗",3),

	;

	/**成员变量*/
	private String name;
	private Integer value;

	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (RiskPostStatusEnum c : RiskPostStatusEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}

	public static Integer getValue(String name) {
		if (name == null) {
			return null;
		}
		for (RiskPostStatusEnum c : RiskPostStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}

}
