package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险类型枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskCategoryEnum {

	COMMON_EIGHT("普通八大项目",1),
	ERROR_SIX("异常六项",2),
	;

	private String name;
	private Integer value;

	public static String getName(Integer value) {
		for (RiskCategoryEnum c : RiskCategoryEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}
}
