package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举 - 验收方式(1-数据化解;2-佐证材料化解；3-佐证材料永久化解)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskAcceptanceWayEnum {


    /**
     * 数据化解
     */
    DATA("数据化解", 1),

    /**
     *佐证材料化解-特定时间之后(一般来说两个月后会再次生成风险)
     */
    MATERIAL("佐证材料化解-特定时间之后", 2),

    /**
     *佐证材料化解-特定时间之前
     */
    MATERIAL_BEFORE("佐证材料化解-特定时间之前", 3),

    SPECIAL_FOREVER("特殊化解", 4),



    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        for (RiskAcceptanceWayEnum c : RiskAcceptanceWayEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
