package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险验收记录状态枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskAcceptanceStatusEnum {

    DRAFT("草稿", 0),

    PENDING_AUDIT("待审核", 1),

    NO_RECTIFICATION("无需整改", 2),

    FINISHED("完成", 3),

    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        for (RiskAcceptanceStatusEnum c : RiskAcceptanceStatusEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
