package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举 - basic风险状态（1-未化解；2-已化解；3-已中止）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum BasicRiskStatusEnum {

    /**
     * 1-未化解
     */
    UNRESOLVED("未化解", 1),

    /**
     * 2-已化解
     */
    RESOLVED("已化解", 2),

    /**
     * 3-已中止
     */
    STOPPED("已中止", 3),


    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }

        for (BasicRiskStatusEnum c : BasicRiskStatusEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
