package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举 - 设备异常code
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum BCompanyErrorDeviceCodeEnum {

    // 射线装置
    DEVICE_ERR_CODE_1("装置名称", "装置名称为空", 1002),
    DEVICE_ERR_CODE_2("型号", "型号为空", 1003),
    DEVICE_ERR_CODE_3("装置生产厂家", "装置生产厂家为空", 1004),
    DEVICE_ERR_CODE_4("设备编号", "设备编号为空", 1005),
    DEVICE_ERR_CODE_5("主要参数", "主要参数为空", 1006),
    DEVICE_ERR_CODE_6("设备状态", "设备状态为空", 1007),
    DEVICE_ERR_CODE_7("设备类型", "设备类型为空", 1008),
    DEVICE_ERR_CODE_8("装置类型", "装置类型为空", 1009),
    DEVICE_ERR_CODE_9("放射诊疗类别", "放射诊疗类别为空", 1010),
    DEVICE_ERR_CODE_10("放射检查类型", "放射诊疗类别属于“X射线影像诊断”或“介入放射学”，但放射检查类型为空", 1011),
    DEVICE_ERR_CODE_11("出厂日期", "出厂日期为空", 1012),
    DEVICE_ERR_CODE_12("所在场所", "设备状态为“正常”，但所在场所为空", 1013),
    DEVICE_ERR_CODE_13("临床使用科室", "临床使用科室为空", 1014),
    DEVICE_ERR_CODE_14("负责人", "负责人为空", 1015),

    // 非密封放射性核素
    DEVICE_ERR_CODE_15("核素名称", "核素名称为空", 2016),
    DEVICE_ERR_CODE_16("物理状态", "物理状态为空", 2017),
    DEVICE_ERR_CODE_17("最大等效日操作量", "最大等效日操作量为空", 2018),
    DEVICE_ERR_CODE_18("最大等效年操作量", "最大等效年操作量为空", 2019),
    DEVICE_ERR_CODE_19("临床使用科室", "临床使用科室为空", 2020),
    DEVICE_ERR_CODE_20("负责人", "负责人为空", 2021),
    DEVICE_ERR_CODE_21("装置/场所信息", "装置/场所信息为空", 2022),

    // 密封放射源
    DEVICE_ERR_CODE_22("核素名称", "核素名称为空", 3023),
    DEVICE_ERR_CODE_23("出厂活度", "出厂活度为空", 3024),
    DEVICE_ERR_CODE_24("活度测量日期", "活度测量日期为空", 3025),
    DEVICE_ERR_CODE_25("核素生产厂家", "核素生产厂家为空", 3026),
    DEVICE_ERR_CODE_26("放射源状态", "放射源状态为空", 3027),
    DEVICE_ERR_CODE_27("临床使用科室", "临床使用科室为空", 3028),
    DEVICE_ERR_CODE_28("用途", "用途为空", 3029),
    DEVICE_ERR_CODE_29("负责人", "负责人为空", 3030),
    DEVICE_ERR_CODE_30("装置/场所信息", "装置/场所信息为空", 3031),

    // 含密封源装置
    DEVICE_ERR_CODE_31("装置名称", "装置名称为空", 4032),
    DEVICE_ERR_CODE_32("设备编号", "设备编号为空", 4033),
    DEVICE_ERR_CODE_33("型号", "型号为空", 4034),
    DEVICE_ERR_CODE_34("生产厂家", "生产厂家为空", 4035),
    DEVICE_ERR_CODE_35("放射诊疗类别", "放射诊疗类别为空", 4036),
    DEVICE_ERR_CODE_36("设备状态", "设备状态为空", 4037),
    DEVICE_ERR_CODE_37("所在场所", "设备状态为“正常”，但所在场所为空", 4038),
    DEVICE_ERR_CODE_38("临床使用科室", "临床使用科室为空", 4039),
    DEVICE_ERR_CODE_39("负责人", "负责人为空", 4040),
    DEVICE_ERR_CODE_40("放射源信息", "放射源信息为空", 4041)


    ;

    private final String type;
    private final String content;
    private final Integer code;

    public static String getType(Integer value) {
        if (value == null) {
            return "";
        }
        for (BCompanyErrorDeviceCodeEnum c : BCompanyErrorDeviceCodeEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getType();
            }
        }
        return "";
    }

    public static String getContent(Integer value) {
        if (value == null) {
            return "";
        }
        for (BCompanyErrorDeviceCodeEnum c : BCompanyErrorDeviceCodeEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getContent();
            }
        }
        return "";
    }
}



