package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 验收记录 - 验收状态（0-草稿；1-待审核；2-无需整改；3-完成)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum AcceptanceRecordStatusEnum {

	/**
	 *	0-草稿
	 */
	DRAFT("草稿",0),

	/**
	 *	1-待审核/待验收
	 */
	AUDIT("待审核",1),

	/**
	 * 2-无需整改
	 */
	NO_NEED_RECTIFY("无需整改",2),

	/**
	 * 3-完成
	 */
	DONE("完成",3),

	/**
	 * 4-已中止
	 */
	STOPPED("已中止",4);


	;



	private String name;
	private Integer value;
}
