package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 佐证材料类型
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum AcceptanceMaterialsTypeEnum {

    /**
     * 11 - 场所-场所检测-已按要求开展检测
     */
    ROOM_CHECKED("已按要求开展场所检测", 11),
    /**
     * 12 - 场所-场所检测/场所检测超标-未启用
     */
    ROOM_SUSPEND_USE("场所未启用", 12),
    /**
     * 13 - 场所-场所检测超标-已复检
     */
    ROOM_RECHECKED("场所已进行复检", 13),


    /**
     * 16 - 性能-性能检测-已按要求开展性能检测
     */
    DEVICE_CHECKED("已按要求开展性能检测", 16),
    /**
     * 17 - 性能-性能检测超标-已停用
     */
    DEVICE_SUSPEND_USE("设备已暂停使用", 17),
    /**
     * 18 - 性能-性能检测超标-已复检
     */
    DEVICE_RECHECKED("设备已进行复检", 18),


    /**
     * 21 - 在岗体检、离岗体检：已按要求开展离岗体检
     */
    HEALTH_CHECKED_LEAVE("在岗体检、离岗体检风险：已按要求开展离岗体检", 21),
    /**
     * 22 - 在岗体检、离岗体检：人员已离职，无法补充离岗体检
     */
    HEALTH_NOT_SUPPLEMENT("在岗体检、离岗体检风险：人员已离职，无法补充离岗体检", 22),
    /**
     * 25 - 在岗体检：已按要求开在岗体检
     */
    HEALTH_CHECKED_ON("在岗体检风险：已按要求开展在岗体检", 25),
    /**
     * 26 - 在岗体检：无需开展在岗体检-目前暂时脱离放射工作岗位
     */
    HEALTH_CHECKED_ON_TEMP_LEAVE("在岗体检风险：无需开展在岗体检-目前暂时脱离放射工作岗位", 26),
    /**
     * 28 - 岗前体检：已按要求开展岗前体检
     */
    HEALTH_CHECKED_BEFORE("岗前体检风险：已按要求开展岗前体检", 28),

    /**
     * 81 - 体检异常-疑似职业病：已按要求开展...
     */
    PHYSICAL_EXCEPTION_OCC("体检异常-疑似职业病：已按要求开展...", 81),
    /**
     * 82 - 体检异常-职业禁忌症：已按要求开展...
     */
    PHYSICAL_EXCEPTION_CONTRAINDICATION("体检异常-职业禁忌症：已按要求开展...", 82),
    /**
     * 83 - 体检异常-复查：已按要求开展...
     */
    PHYSICAL_EXCEPTION_REVIEW("体检异常-复查：已按要求开展...", 83),
    /**
     * 84 - 个人剂量异常-超剂量照射：已按要求开展...
     */
    OSE_EXCEPTION_OVERDOSE("个人剂量异常-超剂量照射：已按要求开展...", 84),



    /**
     * 31 - 放射防护培训：已按要求开展放射防护培训
     */
    RADIATION_TRAIN("已按要求开展放射防护培训", 31),
    /**
     * 32 - 放射防护培训：无需开展放射防护培训-目前暂时脱离放射工作岗位
     */
    RADIATION_TRAIN_TEMP_LEAVE("无需开展放射防护培训-目前暂时脱离放射工作岗位", 32),
    /**
     * 33 - 放射防护培训：无需开展放射防护培训-目前已离岗（含退休）
     */
    RADIATION_TRAIN_LEAVE("无需开展放射防护培训-目前已离岗（含退休）", 33),

    /**
     * 41 - 个人剂量：已按要求开展个人剂量监测
     */
    DOSE_MONITOR("已按要求开展个人剂量监测", 41),
    /**
     * 42 - 个人剂量：无需开展放个人剂量监测-目前暂时脱离放射工作岗位
     */
    DOSE_MONITOR_TEMP_LEAVE("无需开展个人剂量监测-目前暂时脱离放射工作岗位", 42),
    /**
     * 43 - 个人剂量：无需开展个人剂量监测-目前已离岗（含退休）
     */
    DOSE_MONITOR_LEAVE("无需开展个人剂量监测-目前已离岗（含退休）", 43),

    /**
     * 51 - 许可管理：已按要求开展许可校验
     */
    LICENSE_MANAGEMENT("已按要求开展许可校验", 51),
    /**
     * 61 - 个人防护用品：已按要求开展个人防护用品配置
     */
    PERSONAL_PROTECTIVE_EQUIPMENT("已按要求开展个人防护用品配置", 61),
    /**
     * 71 - 安全装置和警示标识设置：已按要求开展安全装置和警示标识设置
     */
    SAFETY_DEVICES_AND_ALERTS("已按要求开展安全装置和警示标识设置", 71),


    /**
     * 99 - 数据无法接入-外省机构未使用全流程系统
     */
    NO_DATA_SYNC("数据无法接入-外省机构未使用全流程系统", 99);


    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (AcceptanceMaterialsTypeEnum c : AcceptanceMaterialsTypeEnum.values()) {
            if (c.value.equals(value)) {
                return c.name;
            }
        }
        return null;
    }
}
