package cn.smarthse.rho.modules.sys.enums.m;

import java.util.Objects;

public enum DeviceTypeEnum {
    /**
     * 粉尘
     */
    FC(1,1,"粉尘"),
    /**
     *化学毒物
     */
    HXDW(2,0,"化学毒物"),
    /**
     *噪声
     */
    CS(3,2,"噪声"),
    /**
     *高温
     */
    GW(4,4,"高温"),
    /**
     *电离辐射
     */
    DLFS(5,5,"电离辐射"),
    /**
     * 监控
     */
    JK(6,3,"监控"),
    /**
     *其他危害
     */
    QTWH(9,6,"其他危害因素");

    DeviceTypeEnum(Integer key, Integer value, String name){
        this.key=key;
        this.value=value;
        this.name=name;
    }

    /**
     * key 对外的值
     */
    private final Integer key;
    /**
     * 内部使用的值
     */
    private final Integer value;
    private String name;

    public Integer getKey() {
        return key;
    }
    public Integer getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DeviceTypeEnum getThisEnumByKey(Integer key){
        DeviceTypeEnum[] list=DeviceTypeEnum.values();
        for(DeviceTypeEnum dev:list){
            if(Objects.equals(dev.getKey(), key)){
                return dev;
            }
        }
        return null;
    }
    public static String getTypeNameByValue(Integer value){
        DeviceTypeEnum[] list=DeviceTypeEnum.values();
        for(DeviceTypeEnum dev:list){
            if(Objects.equals(dev.getValue(), value)){
                return dev.getName();
            }
        }
        return "";
    }
}
