package cn.smarthse.rho.modules.sys.enums.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 许可状态枚举
 * （0-待确认；1-已确认；2-已退回；3-已终止）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LicenseStatusEnum {

	WAIT_CONFIRM("待确认", 0),
	CONFIRMED("已确认", 1),
	RETURNED("已退回", 2),
	TERMINATED("已终止", 3),

	;

	private String name;
	private Integer status;



}
