package cn.smarthse.rho.modules.sys.enums.health;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum HealthHazardFactorsEnum {

    Code_14001("密封放射源产生的电离辐射", "14001"),
    Code_14002("非密封放射性物质", "14002"),
    Code_14003("X射线装置(含CT机)产生的电离辐射", "14003"),
    Code_14004("加速器产生的电离辐射", "14004"),
    Code_14005("中子发生器产生的电离辐射", "14005"),
    Code_14006("氡及其短寿命子体", "14006"),
    Code_14007("铀及其化合物", "14007"),
    Code_14999("以上未提及的可导致职业病的其他其他放射性因素", "14999"),

    ;

    private final String name;
    private final String code;

    public static String getName(String value) {
        for (HealthHazardFactorsEnum c : HealthHazardFactorsEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }

    public static boolean containValue(String value) {
        for (HealthHazardFactorsEnum c : HealthHazardFactorsEnum.values()) {
            if (c.getCode().equals(value)) {
                return true;
            }
        }
        return false;
    }

}
