package cn.smarthse.rho.modules.sys.enums.health;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum HealthCheckResultEnum {


	ZC("正常","1"),
	FC("复查","2"),
	YSZYB("疑似职业病","3"),
	ZYJJZ("职业禁忌证","4"),
	QT("其他疾病或异常","5"),
	;


	private String name;
	private String value;

	public static String getName(String value) {
		for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}


	public static boolean containValue(String value) {
		for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
			if (c.getValue().equals(value)) {
				return true;
			}
		}
		return false;
	}



	public static boolean isError(String resultCode){
		if(StrUtil.isBlank(resultCode)){
			return false;
		}
		//需求：其他异常的风险算正常
		return resultCode.equals("1") || resultCode.equals("5") ? false : true;
	}

	public static Integer getRiskTypeCode(String resultCode){
		HealthCheckResultEnum temp = null;
		for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
			if (c.getValue().equals(resultCode)) {
				temp = c;
			}
		}

		if(temp == null){
			return null;
		}
		if(temp.getValue().equals(HealthCheckResultEnum.ZC.getValue())){
			return RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
		}

		if(temp.getValue().equals(HealthCheckResultEnum.YSZYB.getValue())){
			return RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue();
		}

		if(temp.getValue().equals(HealthCheckResultEnum.ZYJJZ.getValue())){
			return RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue();
		}

		if(temp.getValue().equals(HealthCheckResultEnum.FC.getValue())){
			return RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue();
		}


		if(temp.getValue().equals(HealthCheckResultEnum.QT.getValue())){
			//其他职业病不算异常风险
			return RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
		}

		return null;
	}
}
