package cn.smarthse.rho.modules.sys.enums.health;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum HealthBodyCheckTypeEnum {


	PRE_POST("岗前","1"),
	ON_POST("在岗","2"),
	DT_ING_POST("离岗时","3"),
	DT_POST("离岗后","4"),
	emergency_POST("应急","5"),
	;


	private String name;
	private String value;

	public static String getName(Integer value) {
		for (HealthBodyCheckTypeEnum c : HealthBodyCheckTypeEnum.values()) {
			if (c.getValue().equals(value.toString())) {
				return c.getName();
			}
		}
		return "";
	}

	public static String getName(String value) {
		for (HealthBodyCheckTypeEnum c : HealthBodyCheckTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return null;
	}


	public static String getValue(String name) {
		for (HealthBodyCheckTypeEnum c : HealthBodyCheckTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getValue();
			}
		}
		return null;
	}

	public static boolean containValue(String value){
		for (HealthBodyCheckTypeEnum c : HealthBodyCheckTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return true;
			}
		}
		return false;
	}

}
