package cn.smarthse.rho.modules.sys.enums.f;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 三同时状态-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum FProjectTypeEnum {

    // （1-新建；2-扩建；3-改建；4-技术引进；5-技术改造）

    TYPE_1("新建", 1),
    TYPE_2("扩建", 2),
    TYPE_3("改建", 3),
    TYPE_4("技术引进", 4),
    TYPE_5("技术改造", 5),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        FProjectTypeEnum[] values = FProjectTypeEnum.values();
        for (FProjectTypeEnum typeEnum : values) {
            if (typeEnum.getValue().equals(value)) {
                return typeEnum.getName();
            }
        }
        return "";
    }

}
