package cn.smarthse.rho.modules.sys.enums.f;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 三同时状态-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum FProjectStatusEnum {

    DRAFT(0,"草稿"),
    PASS(1,"已通过"),
    BACK(2,"被退回"),
    AUDIT(3,"待审核"),
    NOT_NEED_AUDIT(4,"无须审核"),
    CLOSED(5,"已终止"),
    ;

    private final Integer value;
    private final String name;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        FProjectStatusEnum[] values = FProjectStatusEnum.values();
        for (FProjectStatusEnum projectStatusEnum : values) {
            if (projectStatusEnum.getValue().equals(value)) {
                return projectStatusEnum.getName();
            }
        }
        return "";
    }

}
