package cn.smarthse.rho.modules.sys.enums.f;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 三同时状态-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum FProjectRaTypeEnum {

    TYPE_1("X射线影像诊断", 1),
    TYPE_2("介入放射学", 2),
    TYPE_3("核医学", 3),
    TYPE_4("放射治疗", 4),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        FProjectRaTypeEnum[] values = FProjectRaTypeEnum.values();
        for (FProjectRaTypeEnum typeEnum : values) {
            if (typeEnum.getValue().equals(value)) {
                return typeEnum.getName();
            }
        }
        return "";
    }

}
