package cn.smarthse.rho.modules.sys.enums.f;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 三同时状态-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum FProjectDetailStatusEnum {

    UN_FINISH("进行中", 1),
    FINISHED("已完成", 2),
    MISS("合理缺项", 3),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        FProjectDetailStatusEnum[] values = FProjectDetailStatusEnum.values();
        for (FProjectDetailStatusEnum projectStatusEnum : values) {
            if (projectStatusEnum.getValue().equals(value)) {
                return projectStatusEnum.getName();
            }
        }
        return "";
    }

}
