package cn.smarthse.rho.modules.sys.enums.f;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 三同时填写状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum FProjectDetailFillTypeEnum {

    TYPE_1("正常填写", 1),
    TYPE_2("合理缺项", 2),
    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        FProjectDetailFillTypeEnum[] values = FProjectDetailFillTypeEnum.values();
        for (FProjectDetailFillTypeEnum projectStatusEnum : values) {
            if (projectStatusEnum.getValue().equals(value)) {
                return projectStatusEnum.getName();
            }
        }
        return "";
    }

}
