package cn.smarthse.rho.modules.sys.enums.err;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum StaffErrorEnum {


    ID_CARD("idcardErr", CollUtil.toList("正常","身份证为空", "证件号码格式错误")),
	PHONE("phoneErr", CollUtil.toList("正常","手机号码为空", "手机号码格式错误，不符合手机号码格式")),
	RA_TYPE("raTypeErr", CollUtil.toList("正常","职业照射种类及代码为空") ),
	POST("postErr", CollUtil.toList("正常","岗位/工种为空")),
	POST_STATUS("postStatusErr", CollUtil.toList("正常","岗位状态为空")),
	ORG("orgErr", CollUtil.toList("正常","所属部门/科室为空")),
	WE("weErr", CollUtil.toList("正常","工作经历为空", "岗位状态为“离岗”，但最近一条工作经历中未填写离岗时间")),
	RAY_STAFF_TIME("rayStaffTimeErr", CollUtil.toList("正常","成为放射工作人员时间为空"));



	private String field;
	private List<String> cnList;

	public static String getCn(StaffErrorEnum en, Integer index){
		if(index == null){
			return null;
		}
		String cn = en.cnList.get(index);
		return cn.equals("正常") ? null : cn;
	}
}
