package cn.smarthse.rho.modules.sys.enums.err;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanyErrorEnum {


	HOSPITAL_NAME_ERR("hospitalNameErr", CollUtil.toList("正常","放射诊疗机构名称为空")),
	NAME_ERR("nameErr", CollUtil.toList("正常","附属对象(院区)名称为空")),
	CREDIT_CODE_ERR("creditCodeErr", CollUtil.toList("正常","统一社会信用代码为空", "社会信用代码格式错误，不符合信用代码标准格式")),
	MEDICAL_NUCODE_ERR("medicalNucodeErr", CollUtil.toList("正常","全国唯一标识码为空")),
	TYPE_ERR("typeErr", CollUtil.toList("正常","机构类别为空", "机构类别为\"诊所\"，但未选择\"是否口腔诊所\"")),
	FLOOR_NUM_ERR("floorNumErr", CollUtil.toList("正常","床位数为空")),
	REGISTERED_AREA_ID_ERR("registeredAreaIdErr", CollUtil.toList("正常","注册地址行政区划为空","注册地址行政区划未精确到街道一级")),
	REGISTERED_ADDRESS_ERR("registeredAddressErr", CollUtil.toList("正常","注册地址详细地址为空")),
	AREA_ID_ERR("areaIdErr", CollUtil.toList("正常","执业地址行政区划为空","执业地址行政区划未精确到街道一级")),
	ADDRESS_ERR("addressErr", CollUtil.toList("正常","执业地址详细地址为空")),
	LEGAL_NAME_ERR("legalNameErr", CollUtil.toList("正常","法定代表人姓名为空")),
	LEGAL_TEL_ERR("legalTelErr", CollUtil.toList("正常","法定代表人手机号码为空", "法定代表人手机号码格式错误，不符合手机号码格式")),
	MAIN_LEADER_NAME_ERR("mainLeaderNameErr", CollUtil.toList("正常","主要负责人姓名为空")),
	MAIN_LEADER_TEL_ERR("mainLeaderTelErr", CollUtil.toList("正常","主要负责人手机号码为空", "主要负责人手机号码格式错误，不符合手机号码格式")),
	ORG_ERR("orgErr", CollUtil.toList("正常","组织架构为空")),
	STAFF_RAY_ERR("staffRayErr", CollUtil.toList("正常","放射工作人员列表为空")),
	STAFF_RAY_ON_POST_ERR("staffRayOnPostErr", CollUtil.toList("正常","当前在岗的放射工作人员数为0")),
	STAFF_RAY_ERR_TABLE_ERR("staffRayErrTableErr", CollUtil.toList("正常","放射工作人员信息存在异常")),
	RAY_GROUP_ORG_NAME_ERR("rayGroupOrgNameErr", CollUtil.toList("正常","领导机构名称为空")),
	RAY_GROUP_DEPARTMENT_NAME_ERR("rayGroupDepartmentNameErr", CollUtil.toList("正常","日常管理部门名称为空")),
	RAY_GROUP_FOUNDING_FILE_ERR("rayGroupFoundingFileErr", CollUtil.toList("正常","成立文件为空")),
	MANAGER_ERR("managerErr", CollUtil.toList("正常","放射卫生防护管理人员列表为空")),
	MANAGER_PHONE_ERR("managerPhoneErr", CollUtil.toList("正常","放射卫生防护管理人员手机号码为空")),
	MANAGER_PHONE_FORMAT_ERR("managerPhoneFormatErr", CollUtil.toList("正常","放射卫生防护管理人员手机号码格式错误，不符合手机号码格式")),
	E_MACHINE_ROOM_ERR("eMachineRoomErr", CollUtil.toList("正常","场所为空", "当前已启用场所数为0")),
	E_DEVICE_ERR("eDeviceErr", CollUtil.toList("正常","医用射线装置/放射性同位素列表为空", "医用射线装置/放射性同位素信息存在异常"));
	private String field;
	private List<String> cnList;

	public static String getCn(CompanyErrorEnum en, Integer index){
		if(index == null){
			return null;
		}
		String cn = en.cnList.get(index);
		return cn.equals("正常") ? null : cn;
	}
}
