package cn.smarthse.rho.modules.sys.enums.dose;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DoseAuditLogOptTypeEnum {

	SUBMIT("提交",1),
	APPROVED("通过",2),
	RETURNED("退回",3),
	;

	/**成员变量*/
	private String name;
	private Integer value;

	public static Integer getValueByAuditStatus(Integer auditStatus){
		if(auditStatus.equals(DoseAuditStatusEnum.PENDING_REVIEW.getValue())){
			return SUBMIT.getValue();
		}
		if(auditStatus.equals(DoseAuditStatusEnum.APPROVED.getValue())){
			return APPROVED.getValue();
		}
		if(auditStatus.equals(DoseAuditStatusEnum.RETURNED.getValue())){
			return RETURNED.getValue();
		}
		return null;
	}





}
