package cn.smarthse.rho.modules.sys.enums.company;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 防护用品自检：审核状态
 */
@AllArgsConstructor
@Getter
public enum ProtectiveEquipmentStatusEnum {

    DRAFT(0, "草稿"),
    PENDING(1, "待审核"),
    REJECTED(2, "被退回"),
    APPROVED(3, "已审核"),
    TERMINATED(-1, "已终止"),
    ;

    private final Integer value;
    private final String name;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return null;
        }
        for (ProtectiveEquipmentStatusEnum status : ProtectiveEquipmentStatusEnum.values()) {
            if (Objects.equals(value, status.getValue())) {
                return status.getName();
            }
        }
        return null;
    }
}
