package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 设备类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum EdeviceTypeEnum {

	/**
	 * 1-射线装置
	 */
	DEVICE_RAY(1,"射线装置"),
	/**
	 * 2-非密封放射性核素
	 */
	SOURCE_NON_SEALED(2,"非密封放射性核素"),
	/**
	 * 3-密封放射源
	 */
	SOURCE_SEALED(3,"密封放射源"),
	/**
	 * 4-含密封源装置
	 */
	DEVICE_SOURCE(4,"含密封源装置")
	;

	private Integer value;
	private String name;

	public static String getName(Integer value) {
		for (EdeviceTypeEnum item : values()) {
			if (item.value.equals(value)) {
				return item.name;
			}
		}
		return null;
	}

	public static Boolean isExist(Integer value) {
		for (EdeviceTypeEnum item : values()) {
			if (item.value.equals(value)) {
				return true;
			}
		}
		return false;
	}
}
