package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 设备-放射装置 - 放射检查类型
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum EdeviceRayCheckTypeEnum {

	DEVICE_RAY(11,"介入放射学操作"),

	// X射线
	XRAY_DIFF_ROOM(21,"放射诊断学用X射线设备隔室透视、摄影"),
	XRAY_SAME_ROOM(22,"放射诊断学用X射线设备同室透视、摄影"),
	XRAY_TEETH(23,"口内牙片摄影"),
	CT_TEETH(24,"牙科全景体层摄影、口腔CT"),
	CT_BODY_SCAN(25,"CT体层扫描"),
	BEDSIDE_PHOTOGRAPHY(26,"床旁摄影"),
	ORTHOPEDIC_REDUCTION(27,"骨科复位等设备旁操作"),
	;

	private Integer value;
	private String name;


	// 通过name获取value
	public static Integer getCodeByName(String name) {
		for (EdeviceRayCheckTypeEnum item : values()) {
			if (item.name.equals(name)) {
				return item.value;
			}
		}
		return null;
	}

}
