package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * b_company表 licence_status字段
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanyLicenceStatusEnum {

    NORMAL(1, "正常"),
    CLOSE(0, "注销"),
    ;

    private final Integer value;
    private final String name;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyLicenceStatusEnum remind : CompanyLicenceStatusEnum.values()) {
            if (Objects.equals(value, remind.getValue())) {
                return remind.getName();
            }
        }
        return null;
    }

}
