package cn.smarthse.rho.modules.sys.enums.company;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 诊疗许可证校验周期枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanyCertCycleEnum {
	ZHYY			("1030101","一",		1,3,"综合医院"),
	ZYYY			("1030102","一",		1,3,"中医医院"),
	ZXYJHYY			("1030103","一",		1,3,"中西医结合医院"),
	MZYYY			("1030104","一",		1,3,"民族医医院"),
	ZKYY			("1030105","一",		3,3,"专科医院"),
	KFYY			("1030106","一",		3,3,"康复医院"),
	FYBJY			("1030201","二",		3,3,"妇幼保健院"),
	FYBJJHSYFWZX	("1030202","二",		3,3,"妇幼保健计划生育服务中心"),
	SQWSFWZX		("1030301","三",		1,1,"社区卫生服务中心"),
	SQWSFWZ			("1030302","三",		1,1,"社区卫生服务站"),
	ZXWSY			("1030401","四",		1,1,"中心卫生院"),
	XZWSY			("1030402","四",		1,1,"乡(镇)卫生院"),
	JDWSY			("1030403","四",		1,1,"街道卫生院"),
	YLY				("1030501","五",		3,3,"疗养院"),
	ZHMZB			("1030601","六",		1,1,"综合门诊部"),
	ZKMZB			("1030602","六",		1,1,"专科门诊部"),
	ZYMZB			("1030603","六",		1,1,"中医门诊部"),
	ZXYJHMZB		("1030604","六",		1,1,"中西医结合门诊部"),
	MZYMZB			("1030605","六",		1,1,"民族医门诊部"),
	ZS				("1030701","七",		1,1,"诊所"),
	ZYZS			("1030702","七",		1,1,"中医诊所"),
	MZYZS			("1030703","七",		1,1,"民族医诊所"),
	WSY				("1030704","七",		1,1,"卫生所"),
	YWS				("1030705","七",		1,1,"医务所"),
	YWS2			("1030706","七",		1,1,"医务室"),
	WSBJS			("1030707","七",		1,1,"卫生保健所"),
	WSZ				("1030708","七",		1,1,"卫生站"),
	CWSSS			("1030801","八",		1,1,"村卫生室(所)"),
	JJZX			("1030901","九",		3,3,"急救中心"),
	JJZ				("1030902","九",		1,1,"急救站"),
	LCJYZX			("1031001","十",		3,3,"临床检验中心"),
	ZKJBFZY			("1031101","十一",	3,3,"专科疾病防治院"),
	ZKJBFZS			("1031102","十一",	3,3,"专科疾病防治所"),
	ZKJBFZZ			("1031103","十一",	3,3,"专科疾病防治站"),
	HLY				("1031201","十二",	1,1,"护理院"),
	HLZ				("1031202","十二",	1,1,"护理站"),
	YXJCSYS			("1031301","十三",	1,1,"医学检验实验室"),
	BLZDZX			("1031302","十三",	1,1,"病理诊断中心"),
	YXYXZDZX		("1031303","十三",	1,1,"医学影像诊断中心"),
	XYTXZX			("1031304","十三",	1,1,"血液透析中心"),
	ANLHZX			("1031305","十三",	1,1,"安宁疗护中心"),
	YLXDGYZX		("1031306","十三",	1,1,"医疗消毒供应中心"),
	KFYYZX			("1031307","十三",	1,1,"康复医疗中心"),
	HLZX			("1031308","十三",	1,1,"护理中心"),
	JKTJZX			("1031309","十三",	1,1,"健康体检中心"),
	OTHER			("1031401","十四",	1,1,"其他")

	;
	//sys_param表code
	private String code;
	//类型
	private String type;
	//床位数小于等于100的年份的周期
	private Integer lt100Cycle;
	//床位数大于100的年份的周期
	private Integer gte100Cycle;
	//医院名称
	private String name;


	public static Integer getCycle(String code, Integer floorNum){
		for (CompanyCertCycleEnum enumSub :CompanyCertCycleEnum.values()){
			if(enumSub.getCode().equals(code)){
				if(floorNum == null || floorNum<100){
					return enumSub.getLt100Cycle();
				}else{
					return enumSub.getGte100Cycle();
				}
			}
		}
		return null;
	}

	public static List<SysParamVo> getParamList(){
		List<SysParamVo> voList = new ArrayList<>();
		for (CompanyCertCycleEnum value : values()) {
			SysParamVo vo = new SysParamVo();
			vo.setName(value.getName());
			vo.setCode(Integer.valueOf(value.getCode()));
			vo.setType(103l);
			vo.setRemark(value.getType());
			voList.add(vo);
		}

		return voList;
	}


}
