package cn.smarthse.rho.modules.sys.enums.company;

import lombok.Getter;

import java.util.Objects;

/**
 * 医院：公告栏-管理制度文件枚举-enum
 */
@Getter
public enum CompanyCategoryCodeEnum {

    R_LEADERSHIP_GROUP(1, "放射诊疗安全与防护管理领导小组成立文件"),
    R_LICENSE_MANAGEMENT(2, "放射诊疗许可证管理制度"),
    R_EMERGENCY_PLAN(3, "放射事件应急处理预案"),
    R_MONITOR_EVALUATION(4, "放射防护检测与评价制度"),
    R_HEALTH_MANAGEMENT(5, "放射工作人员职业健康管理制度"),
    R_PATIENT_NOTICE(6, "受检者放射危害告知与防护制度"),
    R_QUALITY_ASSURANCE(7, "医疗照射质量保证方案");

    private final Integer code;
    private final String displayName;

    CompanyCategoryCodeEnum(Integer code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public static CompanyCategoryCodeEnum fromCode(Integer code) {
        for (CompanyCategoryCodeEnum e : values()) {
            if (Objects.equals(e.code, code)) {
                return e;
            }
        }
        return null;
    }
}
