package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 医院营业状态
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum BusinessStatusEnum {

    NORMAL(1, "正常营业"),
    STOP(2, "暂停营业"),
    CLOSE(0, "关停"),
    ;

    private final Integer value;
    private final String name;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return null;
        }
        for (BusinessStatusEnum remind : BusinessStatusEnum.values()) {
            if (Objects.equals(value, remind.getValue())) {
                return remind.getName();
            }
        }
        return null;
    }

}
