package cn.smarthse.rho.modules.sys.enums.bind;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum UserBindLogTypeEnum {

    BINDING("绑定手机号码",0),

    REBIND("换绑手机号码",1),

    APPEAL("换绑手机号码申请",2),

    UNBIND("解绑手机号码",3),

    APPEAL_PASS("审核换绑手机申请",4),
    // 解绑后，终止换绑申请是这个类型
    APPEAL_NOPASS("审核换绑手机申请",5),
    // 换绑时，号码和正在申请的号码相同
    APPEAL_ENDBYREBIND("审核换绑手机申请",6);

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        if (value == null) {
            return "";
        }
        for (UserBindLogTypeEnum a : UserBindLogTypeEnum.values()) {
            if (a.getValue().equals(value)) {
                return a.name;
            }
        }
        return "";
    }

}
