package cn.smarthse.rho.modules.sys.enums.bind;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ContactBindAuditStatusEnum {
    NOT_NEED_AUDIT(0,"无须审核"),
    PASS(1,"通过"),
    BACK(2,"退回"),
    AUDIT(3,"-"),
    UNBIND(4,"解绑"),
    END(5,"审核终止")
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        for (ContactBindAuditStatusEnum c : ContactBindAuditStatusEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
